%% Beispielskript

%% Informationen zum Skript
% Beispielskript zur Nutzung der grbl-Funktionen
% Nikolas Arthkamp 11.2021
% fuer: grbl-Version 1.1
% benoetigt MATLAB R2019b oder neuer

%% Skript

% noetige Einstellungen
%Port des Arduino festlegen
port = 'COM4';

% Beispiele von Befehlen
%auszufuehrenden Befehl eingeben
%fehlerhafter Befehl
befehl1 = "fehlerhafterBefehl";
%gueltiger Befehl
befehl2 = "G0 X10";                                         

%Verbindung aufbauen
[ans_connection,ans_bewegungsart,arduinostage] = connect_arduinostage(port);

%Antworten ausgeben
disp(ans_connection);
disp(ans_bewegungsart);

%Befehle fuer Bewegung ausfuehren und pruefen
%Befehl senden
writeline(arduinostage,befehl2);
%Antwort auslesen
ans3 = check_grbl_read(arduinostage,8);
%Antwort ausgeben
disp('Befehl "' + befehl2 + '": ' + string(ans3));

%Befehl senden
writeline(arduinostage,befehl1);
%Antwort auslesen
ans3 = check_grbl_read(arduinostage,8);
%Antwort ausgeben
disp('Befehl "' + befehl1 + '": ' + string(ans3));
%Im Fehlerfall sendet grbl mehr als 8 Zeichen: Auslesen aller noch zu
%sendenden Zeichen um korrekte Folgeantworten zu erhalten.
%Matlab gibt hierbei eine Warnung aus, da mehr Zeichen abgefragt werden,
%als vorhanden sind.
ans3 = check_grbl_read(arduinostage,20);                        

%Verbindung trennen
disconnect_arduinostage(arduinostage);